using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace GGJ
{
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Texture2D characterSprite;
        Texture2D obstacleSprite;
        Texture2D Rock;
        Texture2D Flowers;
        Texture2D FrozenPond;
        Texture2D HolePond;
        Texture2D Leaves;
        Texture2D SnowPile;
        Texture2D TallGrass;
        Texture2D Pond;
        Texture2D Platform;
        Texture2D Fountain;
        Texture2D Controls;
        Texture2D Magic;

        Texture2D Level1Spring;
        Texture2D Level1Winter;
        Texture2D Level1Fall;
        Texture2D Level1Summer;
        Texture2D titlescreen;
        Texture2D introscreen;

        Texture2D empty;

        SoundEffect jump;
        SoundEffect winter;
        SoundEffect spring;
        SoundEffect summer;
        SoundEffect fall;
        static SoundEffect theme;
        SoundEffect reset;
        SoundEffect win;

        bool magic = true;

        //SoundEffectInstance theme1 = theme.CreateInstance();

        GraphicsDevice device;

        int screenWidth;
        int screenHeight;
        int frames;
        int seconds;
        int timeTillDeath = 20;



 

        ELevel level = ELevel.title;

        enum ELevel
        {
            title,
            tutorial,
            level0,
            level1,
            win
        }
        
        internal List<CEntity> entities = new List<CEntity>();

        CPlayer player;

        CEntity platform1;
        CEntity platform2;
        CEntity platform3;
        CEntity platform4;
        CEntity platform5;
        CEntity platform6;
        CEntity platform7;
        CEntity platform8;
        CEntity platform9;
        CEntity platform10;
        CEntity platform11;
        CEntity platform12;
        CEntity platform13;
        CEntity platform14;
        CEntity platform15;
        CEntity platform16;
        CEntity platform17;
        CEntity platform18;
        CEntity platform19;
        CEntity platform20;
        CEntity platform21;
        CEntity platform22;
        CEntity platform23;
        CEntity flower1;
        CEntity flower2;
        CEntity flower3;
        CEntity flower4;
        CEntity flower5;
        CEntity flower6;
        CEntity leaves1;
        CEntity leaves2;
        CEntity leaves3;
        CEntity tallgrass1;
        CEntity tallgrass2;
        CEntity tallgrass3;
        CEntity tallgrass4;
        CEntity tallgrass5;
        CEntity asshole1;
        CEntity asshole2;
        CEntity asshole3;
        CEntity asshole4;
        CEntity floor;
        CEntity plat1;
        CEntity plat2;
        CEntity plat3;
        CEntity plat4;
        CEntity plat5;
        CEntity persistant1;
        CEntity Fountain1;
        CEntity title;
        CEntity intro1;
        CEntity SeasonControls;
        CEntity magic1;
        CEntity Win;
        

        KeyboardState myCurrentKeyboardState;
        KeyboardState myPreviousKeyboardState;

        int currentSeason = 0;

        Rectangle persistant1Rectangles = new Rectangle(428, 475, 324, 18);

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        protected override void Initialize()
        {
            // TODO: Add your initialization logic here
            graphics.PreferredBackBufferWidth = 1024;
            graphics.PreferredBackBufferHeight = 768;
            graphics.IsFullScreen = false;
            graphics.ApplyChanges();
            //theme1.IsLooped = true;
            base.Initialize();
        }

        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);
            device = graphics.GraphicsDevice;

            screenWidth = device.PresentationParameters.BackBufferWidth;
            screenHeight = device.PresentationParameters.BackBufferHeight;

            characterSprite = Content.Load<Texture2D>("lil dude");
            obstacleSprite = Content.Load<Texture2D>("lil dude");
            Rock = Content.Load<Texture2D>("Rock");
            Flowers = Content.Load<Texture2D>("Flowers");
            FrozenPond = Content.Load<Texture2D>("FrozenPond");
            HolePond = Content.Load<Texture2D>("HolePond");
            Leaves = Content.Load<Texture2D>("Leaves");
            SnowPile = Content.Load<Texture2D>("SnowPile");
            TallGrass = Content.Load<Texture2D>("TallGrass");
            Pond = Content.Load<Texture2D>("UnfrozenPond");
            Platform = Content.Load<Texture2D>("platform");
            Fountain = Content.Load<Texture2D>("fountain");
            titlescreen = Content.Load<Texture2D>("Titlescreen");
            introscreen = Content.Load<Texture2D>("intro");
            Controls = Content.Load<Texture2D>("SeasonControls");
            Magic = Content.Load<Texture2D>("Magic");

            jump = Content.Load<SoundEffect>("Jump");
            winter = Content.Load<SoundEffect>("Transition_Winter");
            spring = Content.Load<SoundEffect>("Transition_Spring");
            summer = Content.Load<SoundEffect>("Transition_Summer");
            fall = Content.Load<SoundEffect>("Transition_Fall");
            theme = Content.Load<SoundEffect>("MainTheme");
            reset = Content.Load<SoundEffect>("Leaves_01");
            win = Content.Load<SoundEffect>("WaterCalm");

            Level1Fall = Content.Load<Texture2D>("SeasonsLevel1Fall");
            Level1Spring = Content.Load<Texture2D>("SeasonsLevel1Spring");
            Level1Summer = Content.Load<Texture2D>("SeasonsLevel1Summer");
            Level1Winter = Content.Load<Texture2D>("SeasonsLevel1Winter");

            empty = Content.Load<Texture2D>("empty");

            player = new CPlayer(this, characterSprite, new Vector2(0f, 600f));
            //new CEntity(this, obstacleSprite, new Vector2(0f, 200f));

            //new CEntity(this, obstacleSprite, new Vector2(300f, 200f));
            
            //obstacle = new Rectangle(250, 250, obstacleSprite.Width, characterSprite.Height);

            LoadLevel(ELevel.title);
        }

        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
            
        }

        private void LoadLevel(ELevel level)
        {
            //DISPOSE SHIT
            for (int i = entities.Count - 1; i >= 0; --i)
            {
                if (!(entities[i] is CPlayer))
                {
                    entities[i].Dispose();
                }
            }

            DestroySeason();


            this.level = level;


            //PART OF ALL LEVELS
            floor = new CEntity(this, empty, new Vector2(0, 740));


            switch (level)
            {
                case ELevel.title:
                     title = new CEntity(this, titlescreen, new Vector2(0, 0));
                    //theme1.Play();
                    //theme.Play();
                    SoundEffectInstance theme1 = theme.CreateInstance();
                    theme1.IsLooped = true;
                    theme1.Play();
                    break;

                case ELevel.tutorial:
                    intro1 = new CEntity(this, introscreen, new Vector2(0, 0));
                    break;

                case ELevel.level1:
                    //static
                    platform1 = new CEntity(this, Rock, new Vector2(280, 565));
                    platform2 = new CEntity(this, Rock, new Vector2(847, 650));
                    platform3 = new CEntity(this, Rock, new Vector2(475, 640));
                    platform4 = new CEntity(this, Rock, new Vector2(847, 580));
                    platform5 = new CEntity(this, Rock, new Vector2(847, 520));
                    platform6 = new CEntity(this, Rock, new Vector2(847, 460));
                    platform7 = new CEntity(this, Rock, new Vector2(1024, 768));
                    platform8 = new CEntity(this, Rock, new Vector2(1024, 708));
                    platform9 = new CEntity(this, Rock, new Vector2(1024, 648));
                    platform10 = new CEntity(this, Rock, new Vector2(1024, 588));
                    platform11 = new CEntity(this, Rock, new Vector2(1024, 528));
                    platform12 = new CEntity(this, Rock, new Vector2(1024, 468));
                    platform13 = new CEntity(this, Rock, new Vector2(1024, 408));
                    platform14 = new CEntity(this, Rock, new Vector2(1024, 348));
                    platform15 = new CEntity(this, Rock, new Vector2(1024, 288));
                    platform16 = new CEntity(this, Rock, new Vector2(1024, 228));
                    platform17 = new CEntity(this, Rock, new Vector2(1024, 168));
                    platform18 = new CEntity(this, Rock, new Vector2(1024, 108));
                    platform19 = new CEntity(this, Rock, new Vector2(1024, 48));
                    platform20 = new CEntity(this, Rock, new Vector2(1024, -28));
                    platform21 = new CEntity(this, Rock, new Vector2(-75, 700));
                    platform22 = new CEntity(this, Rock, new Vector2(-75, 640));
                    platform23 = new CEntity(this, Rock, new Vector2(-75, 580));
                    //              platform5 = new CEntity(this, Rock, new Vector2(635 + (int)Rock.Width, 675));
                    //             platform6 = new CEntity(this, Rock, new Vector2(635 + (float)Rock.Width / 2, 675 - Rock.Height));
                    //           platform7 = new CEntity(this, Rock, new Vector2(635 + ((float)Rock.Width) / 2, 675 - (2 * Rock.Height)));
                    //         platform8 = new CEntity(this, Rock, new Vector2(635 + ((float)Rock.Width) / 2, 675 - (3 * Rock.Height)));
                    plat1 = new CEntity(this, Platform, new Vector2(180, 650));
                    plat2 = new CEntity(this, Platform, new Vector2(425, 475));
                    plat3 = new CEntity(this, Platform, new Vector2(490, 475));
                    plat4 = new CEntity(this, Platform, new Vector2(490, 380));
                    plat5 = new CEntity(this, Platform, new Vector2(700, 290));
                    Fountain1 = new CEntity(this, Fountain, new Vector2(890, 650));
                    SeasonControls = new CEntity(this, Controls, new Vector2(0, 0));
                    //plat1 = new CEntity(this, Platform, new Vector2(500 + (int)Platform.Width, 450));
                    ChangeSeason(2);
                    break;
                case ELevel.level0:
                    //static
                    platform1 = new CEntity(this, Rock, new Vector2(352, 490));
                    platform2 = new CEntity(this, Rock, new Vector2(847, 650));
                    platform3 = new CEntity(this, Rock, new Vector2(446, 656));
                    platform4 = new CEntity(this, Rock, new Vector2(635, 675));
                    platform5 = new CEntity(this, Rock, new Vector2(635 + (int)Rock.Width, 675));
                    platform6 = new CEntity(this, Rock, new Vector2(635 + (float)Rock.Width / 2, 675 - Rock.Height));
                    platform7 = new CEntity(this, Rock, new Vector2(635 + ((float)Rock.Width) / 2, 675 - (2 * Rock.Height)));
                    platform8 = new CEntity(this, Rock, new Vector2(635 + ((float)Rock.Width) / 2, 675 - (3 * Rock.Height)));
                    plat1 = new CEntity(this, Platform, new Vector2(309, 577));
                    plat2 = new CEntity(this, Platform, new Vector2(500, 450));
                    SeasonControls = new CEntity(this, Controls, new Vector2(0, 0));
                    Fountain1 = new CEntity(this, Fountain, new Vector2(890, 650));
                    ChangeSeason(1);

                    break;
            }


            
            
            
        }

        private void DestroySeason()
        {
            switch (currentSeason)
            {

                case 1:
                    if (level == ELevel.level1)
                    {
                        DestroyEntity(ref flower1);
                        DestroyEntity(ref flower2);
                        DestroyEntity(ref flower3);
                        DestroyEntity(ref flower4);

                    }
                    else if (level == ELevel.level0)
                    {
                        DestroyEntity(ref flower5);
                        DestroyEntity(ref flower6);

                    }
                    break;
                case 2:
                    if (level == ELevel.level1)
                    {
                        DestroyEntity(ref tallgrass1);
                        DestroyEntity(ref tallgrass2);
                        DestroyEntity(ref tallgrass3);
                        DestroyEntity(ref tallgrass4);

                        //tallgrass2.Dispose();
                        // tallgrass2 = null; 
                    }
                    else if (level == ELevel.level0)
                    {
                        DestroyEntity(ref tallgrass5);
                        
                    }
                    break;

                case 3:
                    if (level == ELevel.level1)
                    {
                        DestroyEntity(ref leaves1);

                        // leaves2.Dispose();
                        // leaves2 = null;
                    }
                    else if (level == ELevel.level0)
                    {
                        DestroyEntity(ref leaves2);
                        DestroyEntity(ref leaves3);

                    }
                    break;
                case 4:
                    if (level == ELevel.level1)
                    {
                        DestroyEntity(ref asshole1);
                        DestroyEntity(ref asshole2);
                    }
                    else if (level == ELevel.level0)
                    {
                        DestroyEntity(ref asshole3);
                        DestroyEntity(ref asshole4);

                    }
                    break;
            }
        }

        private void DestroyEntity(ref CEntity entity)
        {
            if (entity != null)
            {
                entity.Dispose();
                entity = null;
            }
        }

        private void ChangeSeason(int season)
        {
            if (currentSeason == season)
                return;

            DestroySeason();


            //CREATE STUFF FOR SEASON
            //CREATES SHIT


            //persistant1 = new CEntity(this, empty, new Vector2(persistant1Rectangles.X, persistant1Rectangles.Y));
            switch (season)
            {
                case 1:
                    if (level == ELevel.level1)
                    {

                        flower1 = new CEntity(this, Flowers, new Vector2(130, 670));
                        flower2 = new CEntity(this, Flowers, new Vector2(215, 600));
                        flower3 = new CEntity(this, Flowers, new Vector2(445, 425));
                        flower4 = new CEntity(this, Flowers, new Vector2(385, 670));

                        //platform = new CEntity(this, obstacleSprite, new Vector2(100 + (int)characterSprite.Width, 400f));
                        //floor = new CEntity(this, empty, new Vector2(0, 740));
                        //persistant1 = new CEntity(this, empty, new Vector2(persistant1Rectangles.X, persistant1Rectangles.Y));
                    }
                    else if (level == ELevel.level0)
                    {
                        flower5 = new CEntity(this, Flowers, new Vector2(390, 690));
                        flower6 = new CEntity(this, Flowers, new Vector2(400, 535));
                        
                    }
                    spring.Play();
                    
                    break;
                case 2:
                    if (level == ELevel.level1)
                    {

                        tallgrass1 = new CEntity(this, TallGrass, new Vector2(90, 640));
                        tallgrass2 = new CEntity(this, TallGrass, new Vector2(345, 525));
                        tallgrass3 = new CEntity(this, TallGrass, new Vector2(640, 350));
                        tallgrass4 = new CEntity(this, TallGrass, new Vector2(600, 640));
                        //tallgrass2 = new CEntity(this, TallGrass, new Vector2(352, 465));

                        //floor = new CEntity(this, empty, new Vector2(0, 740));
                        //persistant1 = new CEntity(this, empty, new Vector2(persistant1Rectangles.X, persistant1Rectangles.Y));
                    }
                    else if (level == ELevel.level0)
                    {
                        tallgrass5 = new CEntity(this, TallGrass, new Vector2(525, 605));

                    }
                    summer.Play();
                    
                    break;
                case 3:
                    if (level == ELevel.level1)
                    {

                        leaves1 = new CEntity(this, Leaves, new Vector2(600, 640));
                        //leaves2 = new CEntity(this, Leaves, new Vector2(911, 651));

                        //floor = new CEntity(this, empty, new Vector2(0, 740));
                        //persistant1 = new CEntity(this, empty, new Vector2(persistant1Rectangles.X, persistant1Rectangles.Y));
                    }
                    else if (level == ELevel.level0)
                    {
                        leaves2 = new CEntity(this, Leaves, new Vector2(786, 651));
                        leaves3 = new CEntity(this, Leaves, new Vector2(911, 651));
                    }
                    fall.Play();
                    
                    break;
                case 4:
                    if (level == ELevel.level1)
                    {

                        asshole1 = new CEntity(this, SnowPile, new Vector2(130, 656));
                        asshole2 = new CEntity(this, SnowPile, new Vector2(600, 640));

                        //floor = new CEntity(this, empty, new Vector2(0, 740));
                        //persistant1 = new CEntity(this, empty, new Vector2(persistant1Rectangles.X, persistant1Rectangles.Y));
                    }
                    else if (level == ELevel.level0)
                    {
                        asshole3 = new CEntity(this, SnowPile, new Vector2(348, 675));
                        asshole4 = new CEntity(this, SnowPile, new Vector2(786, 651));
                    }
                    winter.Play();
                    break;
            }

            currentSeason = season;
        }


        protected override void Update(GameTime gameTime)
        {
            //theme1.IsLooped = true;
            

            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            
            myPreviousKeyboardState = myCurrentKeyboardState;
            myCurrentKeyboardState = Keyboard.GetState();


            if (myCurrentKeyboardState.IsKeyDown(Keys.Up) && myPreviousKeyboardState.IsKeyUp(Keys.Up))
            {
                jump.Play();
            }
            if (myCurrentKeyboardState.IsKeyDown(Keys.R) && myPreviousKeyboardState.IsKeyUp(Keys.R))
            {
                reset.Play();
            }



            if (myCurrentKeyboardState.IsKeyDown(Keys.W) && myPreviousKeyboardState.IsKeyUp(Keys.W))
            {
                //platform = new CEntity(this, obstacleSprite, new Vector2(100 + (int)characterSprite.Width, 400f));
                ChangeSeason(1);
            }
            if (myCurrentKeyboardState.IsKeyDown(Keys.A) && myPreviousKeyboardState.IsKeyUp(Keys.A))
            {
                //platform = new CEntity(this, obstacleSprite, new Vector2(100 + (int)characterSprite.Width, 400f));
                ChangeSeason(2);
            }
            if (myCurrentKeyboardState.IsKeyDown(Keys.S) && myPreviousKeyboardState.IsKeyUp(Keys.S))
            {
                //platform = new CEntity(this, obstacleSprite, new Vector2(100 + (int)characterSprite.Width, 400f));
                ChangeSeason(3);
            }
            if (myCurrentKeyboardState.IsKeyDown(Keys.D) && myPreviousKeyboardState.IsKeyUp(Keys.D))
            {
                //platform = new CEntity(this, obstacleSprite, new Vector2(100 + (int)characterSprite.Width, 400f));
                ChangeSeason(4);
            }

            if (myCurrentKeyboardState.IsKeyDown(Keys.Down))
            {
                //entities.Find(platform);
                /*if (platform != null)
                {
                    platform.Dispose();
                    platform = null;
                }*/
            }
           
  
           
            // TODO: Add your update logic here
            for (int i = entities.Count - 1; i >= 0; i--)
            {
                entities[i].Update();
            }

            //TODO: FIX THIS SHIT
            if (level == ELevel.title)
            {
                if (myCurrentKeyboardState.IsKeyDown(Keys.Enter) && myPreviousKeyboardState.IsKeyUp(Keys.Enter))
                {
                    //clean this up, don't need to dispose


                    LoadLevel(ELevel.tutorial);
                }
            }
            else if (level == ELevel.tutorial)
            {
                if (myCurrentKeyboardState.IsKeyDown(Keys.Space) && myPreviousKeyboardState.IsKeyUp(Keys.Space))
                {
                   
                    LoadLevel(ELevel.level0);
                }
            }
            else if (level == ELevel.win)
            {
                if (magic)
                {
                    Win = new CEntity(this, Magic, new Vector2(0, 0));
                    win.Play();
                    magic = false;
                }

            }
            else if (player.myRectangle.X >= 890 && player.myRectangle.Y >= 550)
            {
                player.myRectangle.Y = 600;
                player.myRectangle.X = 0;
                LoadLevel(level + 1);
            }


            base.Update(gameTime);

        }
        

        protected override void Draw(GameTime gameTime)
        {
            //GraphicsDevice.Clear(Color.CornflowerBlue);

            // TODO: Add your drawing code here


            //backgrounds
            spriteBatch.Begin();
            switch (currentSeason)
            {
                case 1:
                    spriteBatch.Draw(Level1Spring, new Vector2(0, 0), Color.White);
                    break;
                case 2:
                    spriteBatch.Draw(Level1Summer, new Vector2(0, 0), Color.White);
                    break;
                case 3:
                    spriteBatch.Draw(Level1Fall, new Vector2(0, 0), Color.White);
                    break;
                case 4:
                    spriteBatch.Draw(Level1Winter, new Vector2(0, 0), Color.White);
                    break;
            }
            spriteBatch.End();




            spriteBatch.Begin();
            
            for (int i = 0; i < entities.Count; ++i)
            {
                entities[i].Draw(spriteBatch);
            }
            
            spriteBatch.End();

            base.Draw(gameTime);
        }

        
        

//        void DisposeAll()
//        {
//            for (int i = entities.Count - 1; i >= 0; --i)
//            {
//                if (!(entities[i] is CPlayer))
//                {
//                    entities[i].Dispose();
//                }
//            }
//        }
        

    }
}
